Name: iavf-kmp
Summary: Intel(R) Ethernet Adaptive Virtual Function Driver
Version: 4.9.1
Release: 1.sles15sp5
Source0: %{name}-%{version}.tar.bz2
License: GPL-2.0
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: %kernel_module_package_buildreqs pciutils-ids dracut
Requires: pciutils-ids
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%define kernel_ver_number %(uname -r | cut -d- -f1)-%(uname -r | cut -d- -f2)
%define debug_package %{nil}
%global __strip /bin/true

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL} 
%else
%define kernel_ver %(uname -r)
%endif

%if 0%{?KSRC:1}
%define check_aux_args_ksrc -k %{KSRC}
%endif

%define check_aux_args %check_aux_args_kernel %check_aux_args_ksrc
%define need_aux_rpm %( [ -L /lib/modules/%kernel_ver/source ] && (rpm -q --whatprovides /lib/modules/%kernel_ver/source/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) || (rpm -q --whatprovides /lib/modules/%kernel_ver/build/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) )

%(cat > %{_builddir}/%{name}.files << EOF
/etc/modprobe.d/iavf.conf

%defattr(-,root,root)
/lib/modules/%2-%1/updates/iavf.ko
/usr
%{_mandir}/man7/iavf.7.gz
/usr/share/pci.ids.d/pci.ids.%{name}-%{version}
%doc source/COPYING
%doc source/README
%exclude /lib/modules/%2-%1/extern-symvers/intel_auxiliary.symvers
%exclude /lib/modules/%2-%1/updates/drivers/net/ethernet/intel/auxiliary/intel_auxiliary.ko
%exclude /lib/modules/%2-%1/source/include/linux/auxiliary_bus.h
EOF)

%description
This package contains the Intel(R) Ethernet Adaptive Virtual Function Driver.

%if (%need_aux_rpm == 2)
%(echo "Requires: intel_auxiliary-%1" > %{_builddir}/preamble)
%kernel_module_package -f %{_builddir}/%{name}.files -p %{_builddir}/preamble -r %{release} -n iavf -b
%else
%kernel_module_package -f %{_builddir}/%{name}.files -r %{release} -n iavf -b
%endif

%package KMP
Summary: Intel(R) Ethernet Adaptive Virtual Function Driver kernel module
Group: System/Kernel

%description KMP
This package contains the Intel(R) Ethernet Adaptive Virtual Function Driver.

%prep
%setup -q
set -- *
mkdir source
mv "$@" source/.
echo "iavf.ko external" > source/Module.supported
mkdir obj

%if (%need_aux_rpm == 2)
echo "intel_auxiliary.ko external" >> source/Module.supported
%endif

%build
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
# flavors_to_build and kernel_source defined by kernel_module_package
for flavor in %flavors_to_build; do
	export _ksrc=/lib/modules/%kernel_ver_number-$flavor/source
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	BUILD_KERNEL=%kernel_ver_number-$flavor KBUILD_OUTPUT=/lib/modules/%kernel_ver_number-$flavor/build make -C $PWD/obj/$flavor/src KSRC=$_ksrc
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
	export _ksrc=/lib/modules/%kernel_ver_number-$flavor/source
	BUILD_KERNEL=%kernel_ver_number-$flavor KBUILD_OUTPUT=/lib/modules/%kernel_ver_number-$flavor/build make -C $PWD/obj/$flavor/src KSRC=$_ksrc \
		MANDIR=%{_mandir} modules_install mandocs_install
done
mkdir -p $RPM_BUILD_ROOT/usr/share/pci.ids.d
install -D -m 0644 source/pci.updates \
	$RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.%{name}-%{version}

cd %{buildroot}
for flavor in %flavors_to_build; do
find .  -path  "*-$flavor*" \( -name "intel_auxiliary.ko" -or -name auxiliary_bus.h \) \
	-fprintf %{_builddir}/%{name}-%{version}/aux-$flavor.list "/%p\n"
done

for flavor in %flavors_to_build; do
export _ksrc=%{kernel_source $flavor}
cd %{buildroot}/lib/modules/%kernel_ver_number-$flavor
# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif
done

%clean
rm -rf %{buildroot}

%{expand:%(
for flavor in %flavors_to_build; do
echo "%triggerin -n %{name}-$flavor -- %{name}-$flavor"
echo "/usr/bin/merge-pciids"
done
)}

%{expand:%( 
for flavor in %flavors_to_build; do 
echo "%package -n intel_auxiliary-$flavor" 
echo "Summary: Auxiliary bus driver (backport)" 
echo "Version: 1.0.1" 
echo "Release: 1.sles15sp5" 
echo " " 
echo "%description -n intel_auxiliary-$flavor" 
echo "The Auxiliary bus driver (intel_auxiliary.ko), backported from upstream, for use by kernels that don't have auxiliary bus." 
echo " " 
echo "# %if to hide this whole section, causes RPM to not build the subproject at all" 
echo "%if (%need_aux_rpm == 2)" 
echo "%files -n intel_auxiliary-$flavor -f aux-$flavor.list" 
echo "%doc aux-$flavor.list" 
echo "%endif" 
done 
)}

